//
//  MCNetCommGlobals.h
//  MCNetComm
//
//  Created by Fraser Kuyvenhoven on 16/09/08.
//  Copyright 2008 Marketcircle. All rights reserved.
//

#import <Foundation/Foundation.h>


extern NSString *kMCNCCommandKey;

extern BOOL MCNCLogActive;

#define MCNCLogDebug(_format_, _args_...) do { if(MCNCLogActive) MCLogDebug( _format_, ## _args_ ); } while(0)

NSString *MCNCGetIPAddress();


extern NSString *kMCSwitchboardServiceName; // switchboard/cloudserver -- the old switchboard-only service (moving to web)
extern NSString *kMCDatabaseServiceName;    // db aka postgres
extern NSString *kMCWebServiceName;         // web
extern NSString *kMCProxyServiceName;       // front-end for the Mac daemons ... doesn't really have a web url...

extern NSString *kMCHostURLSecuredDefaultsKey; // = @"MCHostURLSecured"; bool; default YES
extern NSString *kMCHostURLSubnetDefaultsKey; // = @"MCHostURLSubnet"; string; default @""
extern NSString *kMCHostURLTLDDefaultsKey; // = @"MCHostURLTLD"; number; 0=net, 1=com, 2=loc

extern NSURL *MCURLForUnqualifiedHostname(NSString *name); // use this to create additional service URLs in app-specific frameworks
extern NSURL *MCURLForCloudID(NSString *name);
extern NSURL *MCHostURLForService(NSString *serviceName);

#define MCSwitchboardHostURL() MCHostURLForService(kMCSwitchboardServiceName)
#define MCDatabaseHostURL()    MCHostURLForService(kMCDatabaseServiceName)
#define MCWebHostURL()         MCHostURLForService(kMCWebServiceName)
#define MCProxyHostURL()       MCHostURLForService(kMCProxyServiceName)


@interface MCNetCommGlobals : NSObject {

}
/*
 Return values of launch arguments
 */
+ (BOOL)isHostedServer;
+ (BOOL)usesSSLProxy;


@end
